// author: RuanShengQiang 
// date: 2017/6/21
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define PI 3.141592653589f

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

bool IsMoreThan(int height, int cell_height, int x, int cur_len)
{
	int len = (int)((x + 1) * height - (float)(x*x + x)* cell_height /2.0f + 0.5f);
	if (len >= cur_len)
		return true;
	else
		return false;
}
#define N 10
__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	float iPro = (3.0f* progress * progress - 2.0f * progress * progress * progress); 	//(3 * T * t * t - 2 * t * t * t) /T/T
	
	int width = W;
	int height = H;
	float4 outputCol;
	float cell_height = 0.1f; //每一小行的高度
	
	float4 y1 = INPUT(input1, param, uv);
	float4 y2 = INPUT(input2, param, uv);

	float cell_matt = 0.0f;
	float temp;
	float pos ;
	for(int i=1;i<=N;i++)
	{
		if(iPro< i/10.0f)
		{
			pos = 1.0f-(iPro-(float)(i-1)/N)*(float)(N+1-i);
			cell_matt = step( 0.0f, uv.y)*step(uv.y, cell_height*(i-1) );
			cell_matt += step( pos, uv.y)*step(uv.y, pos +cell_height );
			break;
		}
	}
/*
	if (iPro<0.1f)
	{
		pos = 1.0-iPro*10.0f;
		cell_matt = step( pos, uv.y)*step(uv.y, pos +cell_height );
	}else if (iPro<0.2f){//0.1
		cell_matt = step( 0, uv.y)*step(uv.y, cell_height );
		pos = 1.0f-(iPro-0.1f)*9.0f;
		cell_matt += step( pos, uv.y)*step(uv.y, pos +cell_height );
	}else if (iPro<0.3f){
		cell_matt = step( 0.0f, uv.y)*step(uv.y, 2.0f*cell_height );
		pos = 1.0f-(iPro-0.2f)*(8.0f);
		cell_matt += step( pos, uv.y)*step(uv.y, pos +cell_height );
	}
*/
	outputCol = mix( y1, y2, cell_matt);

	write_imagef(dstImg, (int2)(w, textH - h -1), outputCol);
}